package gov.va.genisis2.bo;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.util.Helper;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

/**
 * The Class BusinessHelperTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class BusinessHelperTest.
 * 
 *         Description: In this BusinessHelperTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */

@Ignore
public class BusinessHelperTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(BusinessHelperTest.class);

	private BusinessHelper businessHelper;

	private ResponseWrapper wrapper;

	@Before
	public void executedBeforeEach() {
		wrapper = new ResponseWrapper();
		businessHelper = new BusinessHelper();
	}

	/*@Test
	public void validateCopyTableSource() {

		CopyTableSource copyTableSource = Helper.getCopyTableSource();

		assertNotNull(businessHelper.validateCopyTableSource(copyTableSource, copyTableSource, wrapper));
	}*/

	@Test
	public void validateCopyTableSourceNull() {

		CopyTableSource copyTableSourceNull = new CopyTableSource();
		assertNotNull(businessHelper.validateCopyTableSource(copyTableSourceNull, copyTableSourceNull, wrapper));
	}

	@Test
	@Ignore
	public void getWorkflowDeadEnds() {

		List<String> workflowDeadendsList = new ArrayList<String>();
		workflowDeadendsList.add("Denied");
		workflowDeadendsList.add("RequestNotAccepted");
		workflowDeadendsList.add("ResultsNotAccepted");
		workflowDeadendsList.add("Cancelled");
//TODO		businessHelper.setWorkflowDeadendsList(workflowDeadendsList);

		assertTrue(businessHelper.getWorkflowDeadEnds("Denied"));
		assertFalse(businessHelper.getWorkflowDeadEnds("Draft"));

	}

	@Test
	public void isCancelAllowed() {
		assertFalse(businessHelper.isCancelAllowed("Draft"));
		assertTrue(businessHelper.isCancelAllowed("Submitted"));
		assertTrue(businessHelper.isCancelAllowed("Returned"));
		assertTrue(businessHelper.isCancelAllowed("Sent"));
		assertTrue(businessHelper.isCancelAllowed("RequestAccepted"));
		assertTrue(businessHelper.isCancelAllowed("ResultsDelivered"));

	}

	@Test
	public void isOperationAllowed() {

		List<String> allowedOperations = new ArrayList<String>();

		allowedOperations.add("Draft");
		allowedOperations.add("Submitted");
		allowedOperations.add("Denied");
		allowedOperations.add("Returned");

		allowedOperations.add("Sent");
		allowedOperations.add("Update");
		allowedOperations.add("RequestAccepted");
		allowedOperations.add("RequestNotAccepted");

		allowedOperations.add("ResultsAccepted");
		allowedOperations.add("ResultsNotAccepted");
		allowedOperations.add("ResultsDelivered");
		allowedOperations.add("Cancelled");

		businessHelper.setAllowedOperations(allowedOperations);

		assertFalse(businessHelper.isOperationAllowed("Different status"));
		assertTrue(businessHelper.isOperationAllowed("Draft"));
		assertTrue(businessHelper.isOperationAllowed("Submitted"));
		assertTrue(businessHelper.isOperationAllowed("Denied"));
		assertTrue(businessHelper.isOperationAllowed("Returned"));
		assertTrue(businessHelper.isOperationAllowed("Sent"));
		assertTrue(businessHelper.isOperationAllowed("Update"));
		assertTrue(businessHelper.isOperationAllowed("RequestAccepted"));

		assertTrue(businessHelper.isOperationAllowed("RequestNotAccepted"));
		assertTrue(businessHelper.isOperationAllowed("ResultsAccepted"));
		assertTrue(businessHelper.isOperationAllowed("ResultsNotAccepted"));
		assertTrue(businessHelper.isOperationAllowed("ResultsDelivered"));
		assertTrue(businessHelper.isOperationAllowed("Cancelled"));
	}

	@Test
	public void isNotificationAllowed() {

		List<String> notificationAllowed = new ArrayList<String>();

		notificationAllowed.add("Submitted");
		notificationAllowed.add("Denied");
		notificationAllowed.add("Returned");

		notificationAllowed.add("Sent");
		notificationAllowed.add("Update");
		notificationAllowed.add("RequestAccepted");
		notificationAllowed.add("RequestNotAccepted");

		notificationAllowed.add("ResultsAccepted");
		notificationAllowed.add("ResultsNotAccepted");
		notificationAllowed.add("ResultsDelivered");
		notificationAllowed.add("Cancelled");

		businessHelper.setNotificationAllowedStutuses(notificationAllowed);

		assertFalse(businessHelper.isNotificationAllowed("Draft"));
		assertTrue(businessHelper.isNotificationAllowed("Submitted"));
		assertTrue(businessHelper.isNotificationAllowed("Denied"));
		assertTrue(businessHelper.isNotificationAllowed("Returned"));
		assertTrue(businessHelper.isNotificationAllowed("Sent"));
		assertTrue(businessHelper.isNotificationAllowed("Update"));
		assertTrue(businessHelper.isNotificationAllowed("RequestAccepted"));

		assertTrue(businessHelper.isNotificationAllowed("RequestNotAccepted"));
		assertTrue(businessHelper.isNotificationAllowed("ResultsAccepted"));
		assertTrue(businessHelper.isNotificationAllowed("ResultsNotAccepted"));
		assertTrue(businessHelper.isNotificationAllowed("ResultsDelivered"));
		assertTrue(businessHelper.isNotificationAllowed("Cancelled"));
	}

	@Test
	public void isReturnToDDMAllowed() {

		List<String> returnToDDMAllowed = new ArrayList<String>();

		returnToDDMAllowed.add("Sent");
		returnToDDMAllowed.add("RequestAccepted");

		businessHelper.setReturnToDdmAllowedStutuses(returnToDDMAllowed);
		;

		assertTrue(businessHelper.isReturnToDDMAllowed("Sent"));
		assertTrue(businessHelper.isReturnToDDMAllowed("RequestAccepted"));

	}

}
